/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.block.entity;

import dev.ftb.extendedexchange.block.CollectorBlock;
import dev.ftb.extendedexchange.block.entity.AbstractEMCBlockEntity;
import dev.ftb.extendedexchange.block.entity.ModBlockEntityTypes;
import dev.ftb.extendedexchange.block.entity.RelayBlockEntity;
import dev.ftb.extendedexchange.util.EXUtils;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.gameObjs.block_entities.RelayMK1BlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class CollectorBlockEntity
extends AbstractEMCBlockEntity {
    private LazyOptional<IEmcStorage> emcStorageCapability;

    public CollectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.COLLECTOR.get(), blockPos, blockState);
    }

    @Override
    public void tickServer() {
        BlockState state;
        Block block;
        Level level = this.nonNullLevel();
        if (level.m_46467_() % 20L == 0L && (block = (state = this.m_58900_()).m_60734_()) instanceof CollectorBlock) {
            CollectorBlock collector = (CollectorBlock)block;
            this.storedEMC += collector.matter.collectorOutput;
            List<IEmcStorage> validTargets = this.findValidTargets(level);
            if (!validTargets.isEmpty() && this.storedEMC >= (long)validTargets.size()) {
                long perTarget = this.storedEMC / (long)validTargets.size();
                for (IEmcStorage target : validTargets) {
                    long a = target.insertEmc(perTarget, IEmcStorage.EmcAction.EXECUTE);
                    if (a <= 0L) continue;
                    this.storedEMC -= a;
                    this.m_6596_();
                    if (this.storedEMC >= perTarget) continue;
                    break;
                }
            }
        }
    }

    @NotNull
    private List<IEmcStorage> findValidTargets(Level level) {
        ArrayList<IEmcStorage> validTargets = new ArrayList<IEmcStorage>(6);
        for (Direction direction : EXUtils.DIRECTIONS) {
            BlockEntity blockEntity = level.m_7702_(this.f_58858_.m_142300_(direction));
            if (blockEntity == null) continue;
            blockEntity.getCapability(PECapabilities.EMC_STORAGE_CAPABILITY).ifPresent(storage -> {
                validTargets.add((IEmcStorage)storage);
                if (blockEntity instanceof RelayMK1BlockEntity) {
                    RelayMK1BlockEntity relay = (RelayMK1BlockEntity)blockEntity;
                    for (int i = 0; i < 20; ++i) {
                        relay.addBonus();
                    }
                    blockEntity.m_6596_();
                } else if (blockEntity instanceof RelayBlockEntity) {
                    RelayBlockEntity relay = (RelayBlockEntity)blockEntity;
                    relay.addBonus();
                    blockEntity.m_6596_();
                }
            });
        }
        return validTargets;
    }
}

